/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.capability.heat;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.api.capability.heat.CapabilityItemHeat;
import net.dries007.tfc.api.capability.heat.IItemHeat;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class ItemHeatHandler
implements ICapabilitySerializable<NBTTagCompound>,
IItemHeat {
    protected float heatCapacity;
    protected float meltTemp;
    protected float temperature;
    protected long lastUpdateTick;

    public ItemHeatHandler(@Nullable NBTTagCompound nbt, float heatCapacity, float meltTemp) {
        this.heatCapacity = heatCapacity;
        this.meltTemp = meltTemp;
        this.deserializeNBT(nbt);
    }

    public ItemHeatHandler() {
    }

    @Override
    public float getTemperature() {
        return CapabilityItemHeat.adjustTemp(this.temperature, this.heatCapacity, CalendarTFC.PLAYER_TIME.getTicks() - this.lastUpdateTick);
    }

    @Override
    public void setTemperature(float temperature) {
        this.temperature = temperature;
        this.lastUpdateTick = CalendarTFC.PLAYER_TIME.getTicks();
    }

    @Override
    public float getHeatCapacity() {
        return this.heatCapacity;
    }

    @Override
    public float getMeltTemp() {
        return this.meltTemp;
    }

    @Override
    public boolean isMolten() {
        return this.getTemperature() >= this.meltTemp;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHeat.ITEM_HEAT_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(this.hasCapability(capability, facing) ? this : null);
    }

    @Nonnull
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.getTemperature() <= 0.0f) {
            nbt.func_74772_a("ticks", -1L);
            nbt.func_74776_a("heat", 0.0f);
        } else {
            nbt.func_74772_a("ticks", this.lastUpdateTick);
            nbt.func_74776_a("heat", this.temperature);
        }
        return nbt;
    }

    public void deserializeNBT(@Nullable NBTTagCompound nbt) {
        if (nbt != null) {
            this.temperature = nbt.func_74760_g("heat");
            this.lastUpdateTick = nbt.func_74763_f("ticks");
        }
    }
}

